﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class Skills : RPGByteData
    {
        List<Skill> skills;
        
        public Skills(FileStream f)
        {
            load(f);
        }
        public Skills()
        {
        }
        
        override public void load(FileStream f)
        {
            skills = M.readDatabaseList<Skill>(f, "Skills", "Skill", ref M.skillNames);
        }
        
        override protected void myWrite()
        {
            M.writeListNoLength<Skill>(skills);
        }
    }
    
    class Skill : RPGDatabaseEntry
    {
        int id = 0;
        string skillName = ""; // 01
        string skillDescription = ""; // 02
        string useMessage = ""; // 03
        string useMessage2 = ""; // 04
        int failureMessage = 0; // 07
        int classification = 0; // 08
        int mpType = 0; // 09 (2003)
        int mpPercent = 1; // 0a (2003)
        int mpCost = 0; // 0b
        int range = 0; // 0c
        int switchNum = 1; // 0d
        int animation = 1; // 0e
        Audio sound; // 10
        bool onField = true; // 12
        bool inBattle = false; // 13
        bool conditionRemove = false; // 14 (2003)
        int hitRate = 0; // 15
        int mindRate = 3; // 16
        int variance = 4; // 17
        int basicEffect = 0; // 18
        int successRate = 100; // 19
        bool[] statUp; // 1f through 26
        int conditionAffectLength; // 29
        bool[] conditionAffect; // 2a
        int attributeLength; // 2b
        bool[] attributeAssigned; // 2c
        bool defenseUpDown = false; // 2d
        int battlerAnimation = 1; // 31 (2003)
        List<SkillAnimationData> battlerAnimationData; // 32 (2003)
        
        static string myClass = "Skill";
        Chunks chunks;
        
        public Skill(FileStream f)
        {
            load(f);
        }
        public Skill()
        {
        }
        
        public void load(FileStream f)
        {
            chunks = new Chunks(f, myClass);
            
            id = M.readMultibyte(f);
            
            if (chunks.next(0x01))
                skillName = M.readStringDataName(f, id, ref M.skillNames, M.S_TOTRANSLATE);
            
            if (chunks.next(0x02))
                skillDescription = M.readString(f, M.S_TOTRANSLATE);
            if (chunks.next(0x03))
                useMessage = M.readString(f, M.S_TOTRANSLATE);
            if (chunks.next(0x04))
                useMessage2 = M.readString(f, M.S_TOTRANSLATE);
            
            if (chunks.next(0x07))
                failureMessage = M.readLengthMultibyte(f);
            if (chunks.next(0x08))
                classification = M.readLengthMultibyte(f);
            
            if (chunks.next(0x09))
                mpType = M.readLengthMultibyte(f);
            if (chunks.next(0x0a))
                mpPercent = M.readLengthMultibyte(f);
            
            if (chunks.next(0x0b))
                mpCost = M.readLengthMultibyte(f);
            if (chunks.next(0x0c))
                range = M.readLengthMultibyte(f);
            if (chunks.next(0x0d))
                switchNum = M.readLengthMultibyte(f);
            if (chunks.next(0x0e))
                animation = M.readLengthMultibyte(f);
            
            if (chunks.next(0x10))
                sound = new Audio(f);
            
            if (chunks.next(0x12))
                onField = M.readLengthBool(f);
            if (chunks.next(0x13))
                inBattle = M.readLengthBool(f);
            
            if (chunks.next(0x14))
                conditionRemove = M.readLengthBool(f);
            
            if (chunks.next(0x15))
                hitRate = M.readLengthMultibyte(f);
            if (chunks.next(0x16))
                mindRate = M.readLengthMultibyte(f);
            if (chunks.next(0x17))
                variance = M.readLengthMultibyte(f);
            if (chunks.next(0x18))
                basicEffect = M.readLengthMultibyte(f);
            if (chunks.next(0x19))
                successRate = M.readLengthMultibyte(f);
            
            statUp = new bool[8];
            
            if (chunks.next(0x1f)) // HP Up
                statUp[0] = M.readLengthBool(f);
            if (chunks.next(0x20)) // MP Up
                statUp[1] = M.readLengthBool(f);
            if (chunks.next(0x21)) // Attack Up
                statUp[2] = M.readLengthBool(f);
            if (chunks.next(0x22)) // Defense Up
                statUp[3] = M.readLengthBool(f);
            if (chunks.next(0x23)) // Mind Up
                statUp[4] = M.readLengthBool(f);
            if (chunks.next(0x24)) // Agility Up
                statUp[5] = M.readLengthBool(f);
            if (chunks.next(0x25)) // Absorb Up
                statUp[6] = M.readLengthBool(f);
            if (chunks.next(0x26)) // Pierce Up
                statUp[7] = M.readLengthBool(f);
            
            if (chunks.next(0x29))
                conditionAffectLength = M.readLengthMultibyte(f);
            if (chunks.next(0x2a))
                conditionAffect = M.readBoolArray(f);
            
            if (chunks.next(0x2b))
                attributeLength = M.readLengthMultibyte(f);
            if (chunks.next(0x2c))
                attributeAssigned = M.readBoolArray(f);
            
            if (chunks.next(0x2d))
                defenseUpDown = M.readLengthBool(f);
            
            if (chunks.next(0x31))
                battlerAnimation = M.readLengthMultibyte(f);
            if (chunks.next(0x32))
                battlerAnimationData = M.readList<SkillAnimationData>(f);
            
            M.byteCheck(f, 0x00);
        }
        
        public void write()
        {
            M.writeMultibyte(id);
            
            if (chunks.wasNext(0x01))
                M.writeString(skillName, M.S_TOTRANSLATE);
            
            if (chunks.wasNext(0x02))
                M.writeString(skillDescription, M.S_TOTRANSLATE);
            if (chunks.wasNext(0x03))
                M.writeString(useMessage, M.S_TOTRANSLATE);
            if (chunks.wasNext(0x04))
                M.writeString(useMessage2, M.S_TOTRANSLATE);
            
            if (chunks.wasNext(0x07))
                M.writeLengthMultibyte(failureMessage);
            if (chunks.wasNext(0x08))
                M.writeLengthMultibyte(classification);
            
            if (chunks.wasNext(0x09))
                M.writeLengthMultibyte(mpType);
            if (chunks.wasNext(0x0a))
                M.writeLengthMultibyte(mpPercent);
            
            if (chunks.wasNext(0x0b))
                M.writeLengthMultibyte(mpCost);
            if (chunks.wasNext(0x0c))
                M.writeLengthMultibyte(range);
            if (chunks.wasNext(0x0d))
                M.writeLengthMultibyte(switchNum);
            if (chunks.wasNext(0x0e))
                M.writeLengthMultibyte(animation);
            
            if (chunks.wasNext(0x10))
                sound.write();
            
            if (chunks.wasNext(0x12))
                M.writeLengthBool(onField);
            if (chunks.wasNext(0x13))
                M.writeLengthBool(inBattle);
            
            if (chunks.wasNext(0x14))
                M.writeLengthBool(conditionRemove);
            
            if (chunks.wasNext(0x15))
                M.writeLengthMultibyte(hitRate);
            if (chunks.wasNext(0x16))
                M.writeLengthMultibyte(mindRate);
            if (chunks.wasNext(0x17))
                M.writeLengthMultibyte(variance);
            if (chunks.wasNext(0x18))
                M.writeLengthMultibyte(basicEffect);
            if (chunks.wasNext(0x19))
                M.writeLengthMultibyte(successRate);
            
            if (chunks.wasNext(0x1f)) // HP Up
                M.writeLengthBool(statUp[0]);
            if (chunks.wasNext(0x20)) // MP Up
                M.writeLengthBool(statUp[1]);
            if (chunks.wasNext(0x21)) // Attack Up
                M.writeLengthBool(statUp[2]);
            if (chunks.wasNext(0x22)) // Defense Up
                M.writeLengthBool(statUp[3]);
            if (chunks.wasNext(0x23)) // Mind Up
                M.writeLengthBool(statUp[4]);
            if (chunks.wasNext(0x24)) // Agility Up
                M.writeLengthBool(statUp[5]);
            if (chunks.wasNext(0x25)) // Absorb Up
                M.writeLengthBool(statUp[6]);
            if (chunks.wasNext(0x26)) // Pierce Up
                M.writeLengthBool(statUp[7]);
            
            if (chunks.wasNext(0x29))
                M.writeLengthMultibyte(conditionAffectLength);
            if (chunks.wasNext(0x2a))
            {
                M.writeMultibyte(conditionAffect.Length);
                for (int condition = 0; condition < conditionAffect.Length; condition++)
                    M.writeByte(conditionAffect[condition]? 1 : 0);
            }
            
            if (chunks.wasNext(0x2b))
                M.writeLengthMultibyte(attributeLength);
            if (chunks.wasNext(0x2c))
            {
                M.writeMultibyte(attributeAssigned.Length);
                for (int attribute = 0; attribute < attributeAssigned.Length; attribute++)
                    M.writeByte(attributeAssigned[attribute]? 1 : 0);
            }
            
            if (chunks.wasNext(0x2d))
                M.writeLengthBool(defenseUpDown);
            
            if (chunks.wasNext(0x31))
                M.writeLengthMultibyte(battlerAnimation);
            if (chunks.wasNext(0x32))
                M.writeList<SkillAnimationData>(battlerAnimationData);
            
            M.writeByte(0x00);
        }
        
        public bool isBlank()
        {
            if (skillName != "" // 01
             || skillDescription != "" // 02
             || useMessage != "" // 03
             || useMessage2 != "" // 04
             || failureMessage != 0 // 07
             || classification != 0 // 08
             || mpType != 0 // 09 (2003)
             || mpPercent != 1 // 0a (2003)
             || mpCost != 0 // 0b
             || range != 0 // 0c
             || switchNum != 1 // 0d
             || animation != 1 // 0e
             || !sound.isBlank() // 10
             || !onField // 12
             || inBattle // 13
             || conditionRemove // 14
             || hitRate != 0 // 15
             || mindRate != 3 // 16
             || variance != 4 // 17
             || basicEffect != 0 // 18
             || successRate != 100 // 19
             // 1f through 26 below
             // 29 irrelevant (length)
             // 2a below
             // 2b irrelevant (length)
             // 2c below
             || defenseUpDown // 2d
             || battlerAnimation != 1) // 31
             // 32 below
                return false;
            
            for (int i = 0; i < statUp.Length; i++) // 1f through 26
                if (statUp[i])
                    return false;
            
            for (int i = 0; i < conditionAffect.Length; i++) // 2a
                if (conditionAffect[i])
                    return false;
            
            for (int i = 0; i < attributeAssigned.Length; i++) // 2c
                if (attributeAssigned[i])
                    return false;
            
            foreach (SkillAnimationData data in battlerAnimationData) // 32
                if (!data.isBlank())
                    return false;
            
            return true;
        }
    }
    
    class SkillAnimationData : RPGByteData
    {
        int id = 0;
        int movement = 0; // 05
        int afterimages = 0; // 06
        int pose = 4; // 0e
        
        static string myClass = "SkillAnimationData";
        Chunks chunks;
        
        public SkillAnimationData(FileStream f)
        {
            load(f);
        }
        public SkillAnimationData()
        {
        }
        
        override public void load(FileStream f)
        {
            chunks = new Chunks(f, myClass);
            
            id = M.readMultibyte(f);
            
            if (chunks.next(0x05))
                movement = M.readLengthMultibyte(f);
            if (chunks.next(0x06))
                afterimages = M.readLengthMultibyte(f);
            if (chunks.next(0x0e))
                pose = M.readLengthMultibyte(f);
            
            M.byteCheck(f, 0x00);
        }
        
        override protected void myWrite()
        {
            M.writeMultibyte(id);
            
            if (chunks.wasNext(0x05))
                M.writeLengthMultibyte(movement);
            if (chunks.wasNext(0x06))
                M.writeLengthMultibyte(afterimages);
            if (chunks.wasNext(0x0e))
                M.writeLengthMultibyte(pose);
            
            M.writeByte(0x00);
        }
        
        public bool isBlank()
        {
            if (movement != 0 // 05
             || afterimages != 0 // 06
             || pose != 4) // 0e
                return false;
            
            return true;
        }
    }
}
